

# installem els paquets si no estan instal·lats
list.of.packages <- c("runner", "dplyr","plotly", "htmlwidgets", "XML", "RSocrata", "here")
new.packages <- list.of.packages[!(list.of.packages %in% installed.packages()[,"Package"])]
if(length(new.packages)) install.packages(new.packages)

library("RSocrata")
library("here")
require(XML)

library('plotly')
library('htmlwidgets')

library(runner)
library(dplyr)


ma <- function(arr, n=14){
  res = arr
  for(i in n:length(arr)){
    res[i] = mean(arr[(i-n+1):i])
  }
  res
}

# Executar-ho un cop la resta no fa falta, per estalviar temps

# Salut
# casosTotal <- read.socrata("https://analisi.transparenciacatalunya.cat/api/odata/v4/qwj8-xpvk")
# casosPositius <- casosTotal %>% filter(resultatcoviddescripcio != 'Sospitos') #This is no longer needed.
# 
# casosDiaris <- aggregate(casosPositius$numcasos, by=list(casosPositius$data), sum)

############################## ------  Read - Sivic - Files ------ ############################## 

casosDiarisSivic<-read.csv2("..//casosDiarisSivic.csv")
casosDiarisSivic<-casosDiarisSivic[,-1]
colnames(casosDiarisSivic) <- c("data","nous_casos_confirmats")
casosDiarisSivic$data<-as.Date(casosDiarisSivic$data)


defuncionsDiarisSivic<-read.csv2("..//defuncionsDiarisSivic.csv")
defuncionsDiarisSivic<-defuncionsDiarisSivic[,-1]
defuncionsDiarisSivic$Group.1<-as.Date(defuncionsDiarisSivic$Group.1)

hospitalitzatsTotalSivic<-read.csv2("..//hospitalitzatsTotalSivic.csv")
hospitalitzatsTotalSivic<-hospitalitzatsTotalSivic[,-1]
hospitalitzatsTotalSivic$Group.1<-as.Date(hospitalitzatsTotalSivic$Group.1)

uciTotalSivic<-read.csv2("..//uciTotalSivic.csv")
uciTotalSivic<-uciTotalSivic[,-1]
uciTotalSivic$Group.1<-as.Date(uciTotalSivic$Group.1)


############################## ------  END ------ ############################## 

initialDate = as.Date("2019-12-01 CET")


if (length(cell)>0) {
  
  path<-getwd()
  initializeCellsPath<-paste(path,"//..//Initialize.img",sep="")
  etiquetes<-read.table(initializeCellsPath)
  regions_id<-read.table(paste(path,"//..//regions_id.csv",sep=""))
  
  ################################  newInfectiveDetected  #########################################
  
  report<-"newInfectiveDetected"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_newInfectiveDetectedDiary",sep=""),".csv",sep=""))
      
    }
  }
  
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report & report_values$cell==i]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report & report_values$cell==i]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  write.csv2(x = cell_dataframe, file = paste("newInfectiveDetectedDiary",".csv",sep=""))
  
  
  ##############################################################################################################
  
  ################################  newInfective  #########################################
  
  report<-"newInfective"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_newInfectiveDiary",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  write.csv2(x = cell_dataframe, file = paste("newInfectiveDiary",".csv",sep=""))
  
  
  ##############################################################################################################
  
  ################################  newExposedRecovered  #########################################
  
  report<-"newExposedRecovered"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      
      index = c(1:(length(cell_dataframe$cell_time)/10))
      dt1 <- rep(initialDate,length(index))
      datetimes<-dt1+cell_dataframe$cell_time[index*10]
      values<-cell_dataframe$cell_values[index*10]
      cell_dataframe<-data.frame(datetimes,values)
      
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_newExposedRecovered",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("newExposedRecovered",".csv",sep=""))
  
  ##############################################################################################################
  
  ################################  longCovid  #########################################
  
  report<-"layer_long_covid"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      #cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      
      index = c(1:(length(cell_dataframe$cell_time)/10))
      dt1 <- rep(initialDate,length(index))
      datetimes<-dt1+cell_dataframe$cell_time[index*10]
      values<-cell_dataframe$cell_values[index*10]
      cell_dataframe<-data.frame(datetimes,values)
      
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_longCovid",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  #cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("longCovid",".csv",sep=""))
  
  ##############################################################################################################
  
  ###################################################################################
  ################################  exitus  #########################################
  ###################################################################################
  
  ################################  deceased  #######################################
  # Morts d'infectius no s'han detectat 2%
  
  report<-"deceased"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_deceasedDiary",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("deceased",".csv",sep=""))
  
  ################################  deceasedHospital  #######################################
  # Morts d'Hospitalitzats detectats no UCI 2%
  
  report<-"deceasedHospital"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_deceasedHospitalDiary",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("deceasedHospital",".csv",sep=""))
  
  ################################  deceasedUCI  #######################################
  # Morts d'Hospitalitzats detectats no UCI 31% inicial i va variant
  
  report<-"deceasedUCI"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_deceasedUCIDiary",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("deceasedUCI",".csv",sep=""))
  
  ###################################################################################
  ###################################################################################
  ###################################################################################
  
  
  ################################  hospitalization  #########################################
  
  report<-"layer_hospitalization"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      #cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      
      index = c(1:(length(cell_dataframe$cell_time)/10))
      dt1 <- rep(initialDate,length(index))
      datetimes<-dt1+cell_dataframe$cell_time[index*10]
      values<-cell_dataframe$cell_values[index*10]
      cell_dataframe<-data.frame(datetimes,values)
      
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_hospitalization",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  #cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("hospitalization",".csv",sep=""))
  
  ##############################################################################################################
  
  ################################  UCI  #########################################
  
  report<-"layer_UCI"
  
  values <-as.numeric(as.character(report_values$varvalue[report_values$varname == report]))
  time <-as.numeric(as.character(report_values$xTime[report_values$varname == report]))
  report_cell <-as.numeric(as.character(report_values$cell[report_values$varname == report]))
  
  dataframe <-data.frame(time, report_cell, values)
  
  n_length<-length(regions_id$V1)
  
  i=0
  if (length(unique(cell))>1) {
    for (i in 1:n_length) {
      cellName<-etiquetes$V1[i]
      cell_id<-regions_id$V1[i]
      cell_time = dataframe[dataframe$report_cell==(i-1),]$time
      cell_values = dataframe[dataframe$report_cell==(i-1),]$values
      
      values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
      time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
      # Calculo del dt
      dt=cell_time[cell_time>=100 & cell_time<101]
      #cell_values<-sum_run(x=cell_values,k=length(dt))
      
      cell_dataframe<-data.frame(cell_time,cell_values)
      
      index = c(1:(length(cell_dataframe$cell_time)/10))
      dt1 <- rep(initialDate,length(index))
      datetimes<-dt1+cell_dataframe$cell_time[index*10]
      values<-cell_dataframe$cell_values[index*10]
      cell_dataframe<-data.frame(datetimes,values)
      
      write.csv2(x = cell_dataframe, file = paste(paste(cell_id,"_UCI",sep=""),".csv",sep=""))
      
    }
  }
  i=i+1
  cell_time = dataframe[dataframe$report_cell==i-1,]$time
  cell_values = dataframe[dataframe$report_cell==i-1,]$values
  
  values<-as.numeric(as.character(report_values$varvalue[report_values$varname==report]))
  time<-as.numeric(as.character(report_values$xTime[report_values$varname==report]))
  # Calculo del dt
  dt=cell_time[cell_time>=100 & cell_time<101]
  #cell_values<-sum_run(x=cell_values,k=length(dt))
  
  cell_dataframe<-data.frame(cell_time,cell_values)
  
  index = c(1:(length(cell_dataframe$cell_time)/10))
  dt1 <- rep(initialDate,length(index))
  datetimes<-dt1+cell_dataframe$cell_time[index*10]
  values<-cell_dataframe$cell_values[index*10]
  cell_dataframe<-data.frame(datetimes,values)
  
  write.csv2(x = cell_dataframe, file = paste("UCI",".csv",sep=""))
  
  ##############################################################################################################
  
}
######################## Detectats Vs Reals #######################################

report<-"newInfectiveDetected"

#dataframe<-data.frame(time,values)
# 
# 
# n_length<-length(regions_id$V1)
# 
# for (i in 1:n_length) {
#   cellName<-etiquetes$V1[i]
#   cell_id<-regions_id$V1[i]
#   
#   dataframeDetected<-read.csv2(paste(paste(cell_id,"_newInfectiveDetectedDiary",sep=""),".csv",sep=""))
#   
#   # El model sdlps comen?a el dia 29 de gener, seleccionem nom?s els valors dels dts sense decimals, 1 de cada 10.
#   index = c(1:(length(dataframeDetected$cell_time)/10))
#   dt1 <- rep(initialDate,length(index))
#   datetimes<-dt1+dataframeDetected$cell_time[index*10]
#   values<-dataframeDetected$cell_values[index*10]
#   dataframeDetected<-data.frame(datetimes,values)
#   
#   dataframe<-read.csv2(paste(paste(cell_id,"_newInfectiveDiary",sep=""),".csv",sep=""))
#   
#   index = c(1:(length(dataframe$cell_time)/10))
#   dt1 <- rep(initialDate,length(index))
#   datetimes<-dt1+(dataframe$cell_time[index*10])
#   values<-dataframe$cell_values[index*10]
#   dataframe<-data.frame(datetimes,values)
#   
#   dataframeRecoveredExposed<-read.csv2(paste("newExposedRecovered",".csv",sep=""))
#   
#   casosDiaris <- casosTotal 
#   #casosDiaris <- casosDiaris %>% filter(regiosanitariacodi == as.numeric(cell_id))
#   casosDiaris <- casosDiaris %>% filter(codi_ambit == as.numeric(cell_id))
#   
  # casosPositius <- casosDiaris %>% filter(resultatcoviddescripcio != 'Sospit?s')
  # 
  # casosDiaris <- aggregate(casosDiaris$casos, by=list(casosDiaris$data_inici), sum)
  # 
  # casosDiarisMean7 <-ma(casosDiaris$x)
  # 
  # grafica1 <- plot_ly(type="bar", 
  #                     x = casosDiarisSivic$data,
  #                     y = casosDiarisSivic$nous_casos_confirmats/7,
  #                     name = 'observations',
  #                     text = paste("new cases"))
  # 
  # 
  # grafica1 <- add_trace(grafica1, x = ~casosDiaris$Group.1, y = ~casosDiarisMean7, type = 'scatter', mode = 'lines', name="New Cases Mean 7D")
  # grafica1 <- add_trace(grafica1, x = ~dataframe$datetimes, y = ~dataframe$values, type = 'scatter', mode = 'lines', name="New Cases Model")
  # grafica1 <- add_trace(grafica1, x = ~dataframeDetected$datetimes, y = ~dataframeDetected$values, type = 'scatter', mode = 'lines', name="New Cases Detected Model")
  # #  <- add_trace(grafica1, x = ~dataframeRecoveredExposed$datetimes, y = ~dataframeRecoveredExposed$values, type = 'scatter', mode = 'lines', name="Reinfections Model")
  # 
  # grafica1 %>% layout(title = cellName,
  #                     xaxis = list(title = "Time"),
  #                     yaxis = list (title = cellName))
  # 
  # grafica <- paste(cell_id,"_comparative_plotly.html",sep="")
  # htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)
  
#}



casosDiarisPath <- paste("SDLModel\\",paste("casosDiaris",".csv",sep=""),sep="")

cellName<-etiquetes$V1[i+1]
cell_id<-regions_id$V1[i+1]
dataframe<-read.csv2(paste("newInfectiveDiary",".csv",sep=""))

# El model sdlps comença el dia 29 de gener, seleccionem només els valors dels dts sense decimals, 1 de cada 10.
index = c(1:(length(dataframe$cell_time)/10))
dt1 <- rep(initialDate,length(index))
datetimes<-dt1+dataframe$cell_time[index*10]
values<-dataframe$cell_values[index*10]
dataframe<-data.frame(datetimes,values)

dataframeDetected<-read.csv2(paste("newInfectiveDetectedDiary",".csv",sep=""))

# El model sdlps comen?a el dia 29 de gener, seleccionem nom?s els valors dels dts sense decimals, 1 de cada 10.
index = c(1:(length(dataframeDetected$cell_time)/10))
dt1 <- rep(initialDate,length(index))
datetimes<-dt1+dataframeDetected$cell_time[index*10]
values<-dataframeDetected$cell_values[index*10]
dataframeDetected<-data.frame(datetimes,values)


dataframeRecoveredExposed<-read.csv2(paste("newExposedRecovered",".csv",sep=""))


dataframeLongCovid<-read.csv2(paste("longCovid",".csv",sep=""))


grafica1 <- plot_ly(type="bar", 
                    x = casosDiarisSivic$data,
                    y = casosDiarisSivic$nous_casos_confirmats/7,
                    name = 'observations',
                    text = paste("new cases"))

#grafica1 <- add_trace(grafica1, x = ~casosDiaris$Group.1, y = ~casosDiarisMean7, type = 'scatter', mode = 'lines', name="New Cases Mean 7D")
grafica1 <- add_trace(grafica1, x = ~dataframe$datetimes, y = ~dataframe$values, type = 'scatter', mode = 'lines', name="New Cases Model")
grafica1 <- add_trace(grafica1, x = ~dataframeDetected$datetimes, y = ~dataframeDetected$values, type = 'scatter', mode = 'lines', name="New Cases Detected Model")
grafica1 <- add_trace(grafica1, x = ~dataframeRecoveredExposed$datetimes, y = ~dataframeRecoveredExposed$values, type = 'scatter', mode = 'lines', name="Reinfections Model")
grafica1 <- add_trace(grafica1, x = ~dataframeLongCovid$datetimes, y = ~dataframeLongCovid$values, type = 'scatter', mode = 'lines', name="Long Covd Model")

grafica1 %>% layout(title = cellName,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = cellName))

htmlwidgets::saveWidget(as.widget(grafica1), "1_comparative_plotly.html",selfcontained = FALSE)

################################  deceased  #########################################



# El model sdlps comen?a el dia 29 de gener, seleccionem nom?s els valors dels dts sense decimals, 1 de cada 10.

dataframeDeceased<-read.csv2(paste("deceased",".csv",sep=""))

dataframedeceasedHospital<-read.csv2(paste("deceasedHospital",".csv",sep=""))

dataframedeceasedUCI<-read.csv2(paste("deceasedUCI",".csv",sep=""))

dfAux = merge(dataframeDeceased,dataframedeceasedHospital,by = "datetimes", all.x = TRUE)
dfAux = merge(dfAux, dataframedeceasedUCI, by = "datetimes", all.x = TRUE)

aux = data.frame(dfAux$datetimes, (dfAux$values.x+dfAux$values.y+dfAux$values))

colnames(aux) <- c("datetimes","values")

grafica1 <- plot_ly(type="bar",
                    x = defuncionsDiarisSivic$Group.1,
                    y = defuncionsDiarisSivic$x,
                    name = 'exitus',
                    text = paste("exitus"))
grafica1 <- add_trace(grafica1, x = ~aux$datetimes, y = ~aux$values, type = 'scatter', mode = 'lines', name="Exitus SDL")

grafica1 %>% layout(title = cellName,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = cellName))


htmlwidgets::saveWidget(as.widget(grafica1), "1_deceased_plotly.html",selfcontained = FALSE)

###### Aculmulat ######

grafica1 <- plot_ly(type="scatter",
                    x = defuncionsDiarisSivic$Group.1,
                    y = cumsum(defuncionsDiarisSivic$x),
                    name = 'exitus',
                    text = paste("exitus"),
                    mode = "lines")
grafica1 <- add_trace(grafica1, x = ~aux$datetimes, y = ~cumsum(ifelse(is.na(aux$values), 0, aux$values)), type = 'scatter', mode = 'lines', name="Exitus SDL")
grafica1 <- add_trace(grafica1, x = ~defuncionsDiarisSivic$Group.1, y = ~cumsum(defuncionsDiarisSivic$x), type = 'scatter', mode = 'lines', name="Exitus SDL2")

grafica1 %>% layout(title = cellName,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = cellName))


htmlwidgets::saveWidget(as.widget(grafica1), "1_deceased_acumulat_plotly.html",selfcontained = FALSE)

################################  hospitalization  #########################################

dataframeHospitalization<-read.csv2(paste("hospitalization",".csv",sep=""))

grafica1 <- plot_ly(type="bar", 
                    x = hospitalitzatsTotalSivic$Group.1,
                    y = hospitalitzatsTotalSivic$x,
                    name = 'hospitalizations',
                    text = paste("hospitalizations"))
grafica1 <- add_trace(grafica1, x = ~dataframeHospitalization$datetimes, y = ~dataframeHospitalization$values, type = 'scatter', mode = 'lines', name="Hospitalizations SDL")

grafica1 %>% layout(title = cellName,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = cellName))


htmlwidgets::saveWidget(as.widget(grafica1), "1_hospitalization_plotly.html",selfcontained = FALSE)

################################  UCIS  #########################################

dataframeUCI<-read.csv2(paste("UCI",".csv",sep=""))


grafica1 <- plot_ly(type="bar", 
                    x = uciTotalSivic$Group.1,
                    y = uciTotalSivic$x,
                    name = 'UCIs',
                    text = paste("UCIs"))
grafica1 <- add_trace(grafica1, x = ~dataframeUCI$datetimes, y = ~dataframeUCI$values, type = 'scatter', mode = 'lines', name="UCIs SDL")

grafica1 %>% layout(title = cellName,
                    xaxis = list(title = "Time"),
                    yaxis = list (title = cellName))


htmlwidgets::saveWidget(as.widget(grafica1), "1_UCI_plotly.html",selfcontained = FALSE)
